DECLARE @TABLE_SCHEMA VARCHAR(128),
        @TABLE_NAME NVARCHAR(128);
SELECT  @TABLE_SCHEMA = 'S_PRS', 
        @TABLE_NAME = 'T_PERSONNE_PHYSIQUE_PSP';

WITH
T_CONTRAINTES (table_schema, table_name, root_table_schema, root_table_name)
AS (SELECT DISTINCT CTU.TABLE_SCHEMA, CTU.TABLE_NAME, TCT.TABLE_SCHEMA, TCT.TABLE_NAME
    FROM   INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS RFC
           INNER JOIN INFORMATION_SCHEMA.CONSTRAINT_TABLE_USAGE CTU
                 ON RFC.CONSTRAINT_CATALOG = CTU.CONSTRAINT_CATALOG
                    AND RFC.CONSTRAINT_SCHEMA = CTU.CONSTRAINT_SCHEMA
                    AND RFC.CONSTRAINT_NAME = CTU.CONSTRAINT_NAME
           INNER JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS TCT
                 ON RFC.UNIQUE_CONSTRAINT_CATALOG = TCT.CONSTRAINT_CATALOG
                    AND RFC.UNIQUE_CONSTRAINT_SCHEMA = TCT.CONSTRAINT_SCHEMA
                    AND RFC.UNIQUE_CONSTRAINT_NAME = TCT.CONSTRAINT_NAME),
T_TREE_CONTRAINTES (schema_to_delete, table_to_delete, niveau, chemin)
AS (SELECT DISTINCT table_schema, table_name, -1,
           CAST(table_schema+ '.' + table_name AS NVARCHAR(max))
    FROM   T_CONTRAINTES
    WHERE  root_table_name = @TABLE_NAME
      AND root_table_schema = @TABLE_SCHEMA
 
    UNION ALL

    SELECT priorT.table_schema, priorT.table_name, niveau - 1,
           chemin + N', ' + priorT.table_schema + N', ' + priorT.table_name
    FROM   T_CONTRAINTES priorT
           INNER JOIN T_TREE_CONTRAINTES beginT
                 ON beginT.table_to_delete = priorT.root_table_name
                    AND beginT.schema_to_delete = priorT.root_table_schema
    WHERE  priorT.root_table_name <> priorT.table_name
      AND  chemin NOT LIKE 'N%' + priorT.table_schema + ', ' + priorT.table_name + N'%')
SELECT schema_to_delete, table_to_delete
FROM   T_TREE_CONTRAINTES
ORDER  BY niveau;